IF OBJECT_ID('UFD_PDV_VD_IT_RATEIO_POR_SECAO_CUSTO_CONTABIL') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_PDV_VD_IT_RATEIO_POR_SECAO_CUSTO_CONTABIL
	END
  
GO
  
--Select * From UFD_PDV_VD_IT_RATEIO_POR_SECAO_CUSTO_CONTABIL(1,15,'20101101','20101130') Order By CD_CTB_CNT  
CREATE FUNCTION [dbo].[UFD_PDV_VD_IT_RATEIO_POR_SECAO_CUSTO_CONTABIL] (  
        @CD_EMP  INT,  
        @CD_FILIAL INT,  
        @DT_INI      DATETIME,  
        @DT_FIM      DATETIME)  
RETURNS @RS_PROD_VD TABLE (
	   CD_EMP			INT,  
	   CD_FILIAL		INT,
	   DT_VD			DATETIME,
       CD_SC			INT,  
       DS_SC			VARCHAR(150),  
       CD_CTB_CNT_RED   INT,  
       CD_CTB_CNT		VARCHAR(100),         
       VLR_CUSTO         MONEY)  
AS  
BEGIN  
  
INSERT INTO @RS_PROD_VD  
 SELECT  
  PDV_VD.CD_EMP,
  PDV_VD.CD_FILIAL,
  PDV_VD.DT_VD,
  0,    
  '',  
  0,  
  '',
  
     
  --ISNULL(SUM(PDV_VD_IT.VLR_CUSTO_MEDIO *  PDV_VD_IT.QT_IT),0)
  

  ISNULL( SUM(
                  CASE
                           WHEN EST_PROD_CPL.TP_PROD IN (10,11)
                           THEN PDV_VD_IT.TOT_IT    - (PDV_VD_IT.TOT_IT * (EST_PROD_CPL.PERC_COMISSAO_SERVICO / 100))
                           ELSE PDV_VD_IT.QT_IT     * PDV_VD_IT.VLR_CUSTO_MEDIO
                  END),0)
 
    
 FROM           
  PDV_VD INNER JOIN PDV_VD_IT ON  
  PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP AND  
  PDV_VD.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND  
  PDV_VD.CD_VD = PDV_VD_IT.CD_VD  
  INNER JOIN EST_PROD_CPL
			ON       PDV_VD_IT.CD_EMP    = EST_PROD_CPL.CD_EMP
			AND      PDV_VD_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
			AND      PDV_VD_IT.CD_PROD   = EST_PROD_CPL.CD_PROD
 WHERE  
  PDV_VD.CD_EMP = @CD_EMP  
  AND PDV_VD.CD_FILIAL = @CD_FILIAL  
  AND PDV_VD.DT_VD BETWEEN @DT_INI AND @DT_FIM  
  AND PDV_VD.ST_VD = 0  
  AND PDV_VD_IT.ST_IT = 1  
 GROUP BY
	PDV_VD.CD_EMP,
	PDV_VD.CD_FILIAL,
    PDV_VD.DT_VD
RETURN  
END  
  